/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandlerFactory;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ReaderWriterChannel
implements IReaderWriterChannel {
    private static final String NBT_HANDLER = "Handler_%s";
    private final String name;
    private final INetwork network;
    private final List<IWriter> cachedWriters = new ArrayList<IWriter>();
    private final List<IReader> cachedReaders = new ArrayList<IReader>();
    private final List<IReaderWriterHandler> handlers = new ArrayList<IReaderWriterHandler>();

    public ReaderWriterChannel(String name, INetwork network) {
        this.name = name;
        this.network = network;
        this.handlers.addAll(API.instance().getReaderWriterHandlerRegistry().all().stream().map(f -> f.create(null)).collect(Collectors.toList()));
        this.network.getNodeGraph().addListener(() -> {
            this.cachedReaders.clear();
            this.cachedWriters.clear();
            for (INetworkNode node : network.getNodeGraph().allActualNodes()) {
                if (node instanceof IReader && name.equals(((IReader)node).getChannel())) {
                    this.cachedReaders.add((IReader)node);
                    continue;
                }
                if (!(node instanceof IWriter) || !name.equals(((IWriter)node).getChannel())) continue;
                this.cachedWriters.add((IWriter)node);
            }
        });
    }

    @Override
    public List<IReaderWriterHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public void onNodeAdded(INetworkNode node) {
        if (node instanceof IReader) {
            if (!this.cachedReaders.contains(node)) {
                this.cachedReaders.add((IReader)node);
            }
        } else if (node instanceof IWriter) {
            if (!this.cachedWriters.contains(node)) {
                this.cachedWriters.add((IWriter)node);
            }
        } else {
            throw new IllegalArgumentException("Not a reader or writer");
        }
    }

    @Override
    public void onNodeRemoved(INetworkNode node) {
        if (node instanceof IReader) {
            this.cachedReaders.remove(node);
        } else if (node instanceof IWriter) {
            this.cachedWriters.remove(node);
        } else {
            throw new IllegalArgumentException("Not a reader or writer");
        }
    }

    @Override
    public void invalidate() {
        new ArrayList<IWriter>(this.cachedWriters).forEach(w -> w.setChannel(""));
        new ArrayList<IReader>(this.cachedReaders).forEach(r -> r.setChannel(""));
    }

    @Override
    public List<IReader> getReaders() {
        return this.cachedReaders;
    }

    @Override
    public List<IWriter> getWriters() {
        return this.cachedWriters;
    }

    @Override
    public NBTTagCompound writeToNbt(NBTTagCompound tag) {
        for (IReaderWriterHandler handler : this.handlers) {
            tag.func_74782_a(String.format(NBT_HANDLER, handler.getId()), (NBTBase)handler.writeToNbt(new NBTTagCompound()));
        }
        return tag;
    }

    @Override
    public void readFromNbt(NBTTagCompound tag) {
        for (IReaderWriterHandler handler : this.handlers) {
            IReaderWriterHandlerFactory factory;
            String id = String.format(NBT_HANDLER, handler.getId());
            if (!tag.func_74764_b(id) || (factory = API.instance().getReaderWriterHandlerRegistry().get(id)) == null) continue;
            this.handlers.add(factory.create(tag.func_74775_l(id)));
        }
    }
}

